unit fRequest;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ORCtrls, TRPCB, ORFn, ORNet, ComCtrls,
  ORDtTm, Buttons;

type
  TfrmRequest = class(TForm)
    pnl1: TPanel;
    pnl2: TPanel;
    bvl1: TBevel;
    lblFind: TLabel;
    memFind: TMemo;
    lblDiag: TLabel;
    edDiag: TEdit;
    lblBrief: TLabel;
    memBrief: TMemo;
    lblRes: TLabel;
    lblAtt: TLabel;
    lblComp: TLabel;
    lblLen: TLabel;
    edLen: TEdit;
    lblOrd: TLabel;
    lblTyp: TLabel;
    lblStat: TLabel;
    lblDis: TLabel;
    lblNeed: TLabel;
    lblEq: TLabel;
    edNeed: TEdit;
    cbRes: TORComboBox;
    cbAtt: TORComboBox;
    cbStat: TORComboBox;
    cbDis: TORComboBox;
    edOrd: TEdit;
    lblStar2: TLabel;
    lblStar3: TLabel;
    lblStar4: TLabel;
    lblStar5: TLabel;
    lbFinal: TListBox;
    lblHdr2: TLabel;
    lblFroz: TLabel;
    lblTS: TLabel;
    cbFroz: TORComboBox;
    cbTS: TORComboBox;
    lblXray: TLabel;
    cbXray: TORComboBox;
    cbSeq: TORComboBox;
    lblSeq: TLabel;
    lblRef: TLabel;
    edRef: TEdit;
    lblRcom: TLabel;
    memACom: TMemo;
    lblScom: TLabel;
    memSCom: TMemo;
    lblCon: TLabel;
    cbCon: TORComboBox;
    dbDate: TORDateBox;
    ORDateTimeDlg1: TORDateTimeDlg;
    lblDate: TLabel;
    cbType: TORComboBox;
    lblStar6: TLabel;
    pnl4: TPanel;
    pnl3: TPanel;
    bvl2: TBevel;
    btnReq: TButton;
    btnCWait: TButton;
    btnCReq: TButton;
    lblRet: TLabel;
    cbRet: TORComboBox;
    lblRetn: TLabel;
    lblConn: TLabel;
    btnHold: TButton;
    btnSave: TButton;
    btnRet: TButton;
    btnCon: TButton;
    lblPos: TLabel;
    cbPos: TORComboBox;
    btnCan: TBitBtn;
    lstBlood: TListBox;
    lstOther: TListBox;
    lstReturn: TListBox;
    lstConc: TListBox;
    lstRestr: TListBox;
    lstIrr: TListBox;
    memEq: TMemo;
    lblStar7: TLabel;
    pnlProc: TPanel;
    cbProc: TORComboBox;
    lblProc: TLabel;
    lblStar0: TLabel;
    edProc: TEdit;
    lblCPT: TLabel;
    cbCPT: TORComboBox;
    lblLocal: TLabel;
    lblFTProc: TLabel;
    lblOR: TLabel;
    btnSec: TPanel;
    btnBlood: TPanel;
    cbComp: TORComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    cb1: TORComboBox;
    cb2: TORComboBox;
    cb3: TORComboBox;
    memGCom: TMemo;
    lblGComm: TLabel;
    lblLat: TLabel;
    cbLat: TORComboBox;
    lblStar1: TLabel;
    edLoc: TEdit;
    lblLoc: TLabel;
    procedure btnCanClick(Sender: TObject);
    procedure cbResChange(Sender: TObject);
    procedure cbAttChange(Sender: TObject);
    procedure CollectData;
    procedure cbLatClick(Sender: TObject);
    procedure cbResClick(Sender: TObject);
    procedure cbAttClick(Sender: TObject);
    procedure cbStatClick(Sender: TObject);
    procedure cbDisClick(Sender: TObject);
    function CheckEdit(): integer;
    procedure cbProcChange(Sender: TObject);
    procedure cbProcClick(Sender: TObject);
    procedure btnReqClick(Sender: TObject);
    procedure cbTypeClick(Sender: TObject);
    procedure btnCWaitClick(Sender: TObject);
    procedure cbRetChange(Sender: TObject);
    procedure cbConChange(Sender: TObject);
    procedure btnCReqClick(Sender: TObject);
    procedure btnHoldClick(Sender: TObject);
    procedure EditRequest(ReqData: TStrings);
    procedure btnSaveClick(Sender: TObject);
    procedure cbLatChange(Sender: TObject);
    procedure memFindChange(Sender: TObject);
    procedure edDiagChange(Sender: TObject);
    procedure memBriefChange(Sender: TObject);
    procedure edLenChange(Sender: TObject);
    procedure edOrderChange(Sender: TObject);
    procedure cbTypeChange(Sender: TObject);
    procedure cbStatChange(Sender: TObject);
    procedure cbDisChange(Sender: TObject);
    procedure edNeedChange(Sender: TObject);
    procedure dbDateChange(Sender: TObject);
    procedure cbFrozChange(Sender: TObject);
    procedure cbTSChange(Sender: TObject);
    procedure cbXrayChange(Sender: TObject);
    procedure cbSeqChange(Sender: TObject);
    procedure edRefChange(Sender: TObject);
    procedure memAComChange(Sender: TObject);
    procedure memSComChange(Sender: TObject);
    procedure btnConClick(Sender: TObject);
    procedure cbPosChange(Sender: TObject);
    procedure cbPosClick(Sender: TObject);
    procedure cbFrozClick(Sender: TObject);
    procedure cbTSClick(Sender: TObject);
    procedure cbXrayClick(Sender: TObject);
    procedure cbSeqClick(Sender: TObject);
    procedure btnBloodClick(Sender: TObject);
    procedure btnOtherClick(Sender: TObject);
    procedure btnRetClick(Sender: TObject);
    procedure memEqChange(Sender: TObject);
    procedure cbCPTChange(Sender: TObject);
    procedure cbCPTClick(Sender: TObject);
    procedure cbCompChange(Sender: TObject);
    procedure cbCompClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RequiredFields;
    procedure MarkRequired;
    procedure CheckRequired;
    procedure edProcClick(Sender: TObject);
    procedure cbRetClick(Sender: TObject);
    procedure cbConClick(Sender: TObject);
    procedure cb1Click(Sender: TObject);
    procedure cb2Click(Sender: TObject);
    procedure cb3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmRequest: TfrmRequest;
  star0, star1, star2, star3, star4, star5, star6: integer;
  SRifn, Change, BlChange, OtChange, CheckReq, Source: integer;
  Ptifn, wlifn, opcase, PatName, Rdata, ProcName, LProcName, ProcCPT: string;
  LProcIFN, LatIFN, ResIFN, AttIFN, TypeIFN, StatIFN, DisIFN, CPTIFN, CompIFN: string;
  PosIFN, RetIFN, ConIFN, FrozIFN, TSIFN, BP1IFN, BP2IFN, BP3IFN, XrayIFN, SeqIFN: string;

procedure Request(Data: TStrings; Source: integer);

implementation

{$R *.dfm}

uses SCMMain, uCore, fCurrentWait,fOps, fCurrentReq, fRptBox,
     fBlood, fOther;

procedure Request(Data: TStrings; Source: integer);
// Source - 1 = new entry from request note
//          2 = edit entry
//          3 = direct entry
//          4 = AR/WL entry
var
  J, Local: integer;
  Node, Code: string;
begin
  frmRequest := TfrmRequest.Create(Application);
  with frmRequest do
    begin
      lblRetn.Visible := False;
      lblConn.Visible := False;
      Change   := 0;
      BlChange := 0;
      OtChange := 0;
      CheckReq := 0;
      PutFlag  := 0;
      star0    := 0;
      star1    := 0;
      star2    := 0;
      star3    := 0;
      star4    := 0;
      star5    := 0;
      star6    := 0;
      lstOther.Items.Create;
      MarkRequired;
      if UserSite <> 648 then
        begin
          memEq.Enabled    := False;
          lblEq.Enabled    := False;
          lblTS.Enabled    := False;
          cbTS.Enabled     := False;
          lblSeq.Enabled   := False;
          cbSeq.Enabled    := False;
        end;
      if (UsePTLD = 0) then
        begin
          lblLocal.Enabled := False;
          lblProc.Enabled  := False;
          cbProc.Enabled   := False;
          lblOR.Enabled    := False;
          lblStar0.Caption := '';
          edProc.Text      := piece(Data[22],'^', 2);
          LProcIFN         := '';
          LProcName        := '';
          CPTIFN           := piece(Data[22], '^', 3);
          cbCPT.Text       := piece(Data[22], '^', 4);
          ProcCPT          := cbCPT.Text;
          lblCPT.Enabled   := True;
          cbCPT.Enabled    := True;
        end;
      if (UsePtld = 1) and (Source <> 2) then  // for portland
        begin
          CallV('APTWL GET PROC', []);
          cbProc.Items := RPCBrokerV.Results;
          Local := StrToInt(piece(Data[22], '^', 5));
          if Local = 1 then  // portland procedure
            begin
              cbProc.Text := piece(Data[22], '^', 2);
              LProcName   := cbProc.Text;
              LProcIFN    := piece(Data[22], '^', 1);
              ProcName    := '';
              if LProcIFN <> '' then lblStar0.Caption := '';
            end;
          if Local = 0 then  // free text procedure
            begin
              edProc.Text := piece(Data[22],'^', 2);
              ProcName    := edProc.Text;
              LProcName   := '';
              LProcIFN    := '';
              lblStar0.Caption := '';
            end;
          CPTIFN      := piece(Data[22], '^', 3);
          cbCPT.Text  := piece(Data[22], '^', 4);
          ProcCPT     := cbCPT.Text;
        end;
      PatName := piece(Data[0], '^', 2);
      PtIFN   := piece(Data[0], '^', 1);
      if Source <> 2 then  // from note request or AR/WL entry
        begin
          btnSave.Visible := False;
          wlifn       := Data[24];
          Caption     := Caption + PatName;
          if Source = 3 then Caption := 'Direct Entry to Request List for ' + PatName;
          cbLat.Text  := piece(Data[7], '^', 2);
          memFind.Lines[0]  := Data[8];
          edDiag.Text := Data[9];
          memBrief.Lines[0] := Data[10];
          cbRes.Text  := piece(Data[11], '^', 2);
          ResIFN      := piece(Data[11], '^', 1);
          cbAtt.Text  := piece(Data[12], '^', 2);
          AttIFN      := piece(Data[12], '^', 1);
          // edTime.Text := Data[13];    // removed 1-14-08
          edLen.Text  := Data[14];
          cbComp.Text := piece(Data[15], '^', 2);
          edOrd.Text  := Data[16];
          cbType.Text := piece(Data[17], '^', 2);
          cbStat.Text := piece(Data[18], '^', 2);
          cbDis.Text  := piece(Data[19], '^', 2);
          edNeed.Text := Data[20];
          memEq.Lines.Add(Data[21]);
          if Source = 1 then   // note request
            begin
              if Data[43] <> '' then
                begin
                  lstOther.Items.Add(Data[43]);
                  btnSec.Color      := clRed;
                  btnSec.Font.Color := clWhite;
                end;
              if Data[44] <> '' then lstOther.Items.Add(Data[44]);
              if Data[45] <> '' then lstOther.Items.Add(Data[45]);
              if Data[46] <> '' then lstOther.Items.Add(Data[46]);
              if Data[47] <> '' then lstOther.Items.Add(Data[47]);
              if Data[48] <> '' then lstOther.Items.Add(Data[48]);
              for J := 1 to 3 do memGCom.Lines.Add(piece(Data[49], '^', J));
              edLoc.Text := Data[50];
            end;
          if Source = 4 then   // AR/WL
            begin
              if Data[51] <> '' then
                begin
                  lstOther.Items.Add(Data[51]);
                  btnSec.Color      := clRed;
                  btnSec.Font.Color := clWhite;
                end;
              if Data[52] <> '' then lstOther.Items.Add(Data[52]);
              if Data[53] <> '' then lstOther.Items.Add(Data[53]);
              if Data[54] <> '' then lstOther.Items.Add(Data[54]);
              if Data[56] <> '' then lstOther.Items.Add(Data[56]);
              if Data[57] <> '' then lstOther.Items.Add(Data[57]);
              for J := 1 to 3 do memGCom.Lines.Add(piece(Data[58], '^', J));
              edLoc.Text := Data[59];
            end;
          end;
      if Source = 2 then  // from request in file 130
        begin
          lblHdr2.Visible  := False;
          btnReq.Visible   := False;
          btnCWait.Visible := False;
          btnCReq.Visible  := False;
          btnHold.Visible  := True;
          btnSave.Visible  := True;
          lblStar1.Caption := '';
          // lblLat.Enabled   := False;
          // cbLat.Enabled    := False;
          Caption          := 'Edit Surgical Request for ' + PatName;
          PtIFN            := piece(Data[0], '^', 1);
          wlifn            := Data[6];
          opcase           := Data[3];
          if piece(Data[8], '^', 1) <> '' then   // portland procedure
            begin
              cbProc.Text := piece(Data[8], '^', 2);
              LProcIFN     := piece(Data[8], '^', 1);
              lblStar0.Caption := '';
            end
          else  // free text procedure
            begin
              edProc.Text := piece(Data[8], '^', 3);
              lProcIFN     := '';
            end;
          CPTIFN           := piece(Data[9], '^', 1);
          cbCPT.Text       := piece(Data[9], '^', 2);
          cbLat.Text       := piece(Data[10], '^', 2);
          edLoc.Text       := piece(Data[10], '^', 3);
          cbPos.Text       := piece(Data[11], '^', 2);
          PosIFN           := piece(Data[11], '^', 1);
          memFind.Lines[0] := Data[17];
          edDiag.Text      := Data[18];
          memBrief.Lines[0] := Data[16];
          memBrief.Lines[1] := Data[45];
          cbRes.Text       := piece(Data[14], '^', 2);
          ResIFN           := piece(Data[14], '^', 1);
          cbAtt.Text       := piece(Data[15], '^', 2);
          AttIFN           := piece(Data[15], '^', 1);
          edLen.Text       := Data[19];
          edOrd.Text       := Data[20];
          cbType.Text      := piece(Data[21], '^', 2);
          cbStat.Text      := piece(Data[22], '^', 2);
          cbDis.Text       := piece(Data[26], '^', 2);
          dbDate.FMDateTime := StrToFloat(piece(Data[7], '^', 1));
          if Data[43] <> '' then
            begin
              cbRet.Text   := piece(Data[43], '^', 2);
              RetIFN       := piece(Data[43], '^', 1);
              btnRet.Visible := True;
              lstReturn.Items.Add(Data[43]);
            end;
          if Data[46] <> '' then
            begin
              cbCon.Text   := piece(Data[46], '^', 2);
              ConIFN       := piece(Data[46], '^', 1);
              btnCon.Visible := True;
              lstConc.Items.Add(Data[46]);
            end;
          cbFroz.Text      := piece(Data[27], '^', 2);
          FrozIFN          := piece(Data[27], '^', 1);
          cbTS.Text        := piece(Data[28], '^', 2);
          TSIFN            := piece(Data[28], '^', 1);
          cbXray.Text      := piece(Data[32], '^', 2);
          XrayIFN          := piece(Data[32], '^', 1);
          cbSeq.Text       := piece(Data[33], '^', 2);
          SeqIFN           := piece(Data[33], '^', 1);
          edRef.Text       := piece(Data[47], '^', 1);
          if Data[40] <> '' then
            begin
              for J := 1 to 4 do
                begin
                  if piece(Data[40], '^', J) <> '' then memEq.Lines.Add(piece(Data[40], '^', J));
                end;
            end;
          for J := 1 to 2 do memSCom.Lines.Add(piece(Data[42], '^', J));
          for J := 1 to 3 do memGCom.Lines.Add(piece(Data[41], '^', J));
          for J := 29 to 31 do
            begin
              if Data[J] <> '' then
                begin
                  lstBlood.Items.Add(Data[J]);
                  btnBlood.Font.Color := clRed;
                end;
            end;
          for J := 34 to 36 do
            begin
              if Data[J] <> '' then lstRestr.Items.Add(Data[J]);
            end;
          for J := 37 to 39 do
            begin
              if Data[J] <> '' then lstIrr.Items.Add(Data[J]);
            end;
          if Data[12] <> '' then
            begin
              lstOther.Items.Add(Data[12]);
              btnSec.Color      := clRed;
              btnSec.Font.Color := clWhite;
            end;
          if Data[13] <> '' then lstOther.Items.Add(Data[13]);
          if Data[44] <> '' then lstOther.Items.Add(Data[44]);
          if Data[48] <> '' then lstOther.Items.Add(Data[48]);
          if Data[49] <> '' then lstOther.Items.Add(Data[49]);
          if Data[50] <> '' then lstOther.Items.Add(Data[50]);
        end;
      if (UsePTLD = 1) then
        begin
          CallV('APTWL GET PROC', []);
          cbProc.Items := RPCBrokerV.Results;
        end;
      CallV('APTWL GET CPT', []);
      cbCPT.Items := RPCBrokerV.Results;
      CallV('APTWL GET LATERALITY', []);
      cbLat.Items := RPCBrokerV.Results;
      if cbLat.Text = '' then lblStar1.Caption := ''
      else for J := 0 to cbLat.Items.Count-1 do
        begin
          if piece(cbLat.Items[J], '^', 2) = cbLat.Text then
          begin
            LatIFN := piece(cbLat.Items[J], '^', 1);
            lblStar1.Caption := '';
            Break;
          end;
        end;
      CallV('APTWL GET SURG POSITION', []);
      cbPos.Items := RPCBrokerV.Results;
      CallV('APTWL GET PROVIDER', ['S', SpecIFN]);
      cbRes.Items := RPCBrokerV.Results;
      if (cbRes.Text = '') or (cbRes.Text = 'none') or (ResIFN <> '') then lblStar2.Caption := '';
       { begin
          ResIFN := '';
          lblStar2.Caption := '';
        end
      else
        begin
          for J := 0 to cbRes.Items.Count-1 do
            begin
              if piece(cbRes.Items[J], '^', 2) = cbRes.Text then
              begin
                ResIFN := piece(cbRes.Items[J], '^', 1);
                lblStar2.Caption := '';
                Break;
              end;
            end;
        end; }
      cbAtt.Items := RPCBrokerV.Results;
      if (cbAtt.Text = '') or (cbAtt.Text = 'none') or (AttIFN <> '') then lblStar3.Caption := '';
       { begin
          AttIFN := '';
          lblStar3.Caption := '';
        end
      else
        begin
          for J := 0 to cbAtt.Items.Count-1 do
            begin
              if piece(cbAtt.Items[J], '^', 2) = cbAtt.Text then
              begin
                AttIFN := piece(cbAtt.Items[J], '^', 1);
                lblStar3.Caption := '';
                Break;
              end;
            end;
        end; }
      CallV('APTWL GET PTSTAT', []);
      cbStat.Items := RPCBrokerV.Results;
      if cbStat.Text = '' then lblStar4.Caption := ''
      else for J := 0 to cbStat.Items.Count-1 do
        begin
          if piece(cbStat.Items[J], '^', 2) = cbStat.Text then
          begin
            StatIFN := piece(cbStat.Items[J], '^', 1);
            lblStar4.Caption := '';
            Break;
          end;
        end;
      CallV('APTWL GET DISPO', []);
      cbDis.Items := RPCBrokerV.Results;
      if cbDis.Text = '' then lblStar5.Caption := ''
      else for J := 0 to cbDis.Items.Count-1 do
        begin
          if piece(cbDis.Items[J], '^', 2) = UpperCase(cbDis.Text) then
          begin
            DisIFN := piece(cbDis.Items[J], '^', 1);
            lblStar5.Caption := '';
            Break;
          end;
        end;
      CallV('APTWL GET TYPE', []);
      cbType.Items := RPCBrokerV.Results;
      if cbType.Text = '' then lblStar6.Caption := ''
      else for J := 0 to cbType.Items.Count-1 do
        begin
          if piece(cbType.Items[J], '^', 2) = cbType.Text then
          begin
            TypeIFN := piece(cbType.Items[J], '^', 1);
            lblStar6.Caption := '';
            Break;
          end;
        end;
      SRifn := 0;
      lblRetn.Visible := False;
      btnRet.Visible  := False;
      lblConn.Visible := False;
      btnCon.Visible  := False;
      if Source = 1 then
        begin
          lblStar0.Visible := True;
          lblStar1.Visible := True;
          lblStar2.Visible := True;
          lblStar3.Visible := True;
          lblStar4.Visible := True;
          lblStar5.Visible := True;
          lblStar6.Visible := True;
        end;
      ShowModal;
    end;
  frmRequest.Release;
end;


procedure TfrmRequest.btnCanClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmRequest.cbResChange(Sender: TObject);
begin
  if cbRes.Text = '' then Exit;
  CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbRes.Text]);
  cbRes.Items := RPCBrokerV.Results;
  cbRes.DroppedDown := True;
  Change := 1;
end;

procedure TfrmRequest.cbAttChange(Sender: TObject);
begin
  if cbAtt.Text = '' then Exit;
  CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbAtt.Text]);
  cbAtt.Items := RPCBrokerV.Results;
  cbAtt.DroppedDown := True;
  Change := 1;
end;

procedure TfrmRequest.btnReqClick(Sender: TObject);
var
  cnt: integer;
  Success, Tempproc, Result: string;
begin
  CheckRequired;
  if CheckReq = 1 then
    begin
      RequiredFields;
      Exit;
    end;
  if UsePTLD = 0 then Tempproc := edProc.Text
    else Tempproc := cbProc.Text;
  Result := sCallV('APTWL IS REQUESTED?', [PtIFN, SpecIFN, Tempproc, dbDate.FMDateTime]);
  if piece(Result, '^', 1) = '1' then
    begin
      MessageDlg('This enty is already ' + piece(Result, '^', 2) + ' in Vista.' + CRLF +
        'No action will be taken.', mtwarning, [mbOK], 0);
      Exit;
    end;
  if CheckEdit = 0 then
    begin
      cnt := 0;
      MessageDlg('Please edit the data in all "starred" boxes', mtwarning, [mbOK], 0);
      if star0 = 1 then
        begin
          cbProc.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbProc.SetFocus;
              cnt := 1;
            end;
        end;
      if star1 = 1 then
        begin
          cbLat.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbLat.SetFocus;
              cnt := 1;
            end;
        end;
      if star2 = 1 then
        begin
          cbRes.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbRes.SetFocus;
              cnt := 1;
            end;
        end;
      if star3 = 1 then
        begin
          cbAtt.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbAtt.SetFocus;
              cnt := 1;
            end;
        end;
      if star4 = 1 then
        begin
          cbStat.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbStat.SetFocus;
              cnt := 1;
            end;
        end;
      if star5 = 1 then
        begin
          cbDis.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbDis.SetFocus;
              cnt := 1;
            end;
        end;
      if star6 = 1 then
        begin
          cbType.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbType.SetFocus;
              cnt := 1;
            end;
        end;
      Exit;
    end;
  CollectData;
  Success := sCallV('APTWL PUT REQUEST', [lbFinal.Items, lstBlood.Items, lstOther.Items, memBrief.Lines, memACom.Lines, memGCom.Lines]);
  if piece(Success, '^', 1) = '0' then
    begin
      MessageDlg(piece(Success, '^', 2), mterror, [mbOK], 0);
      Exit;
    end
  else
    begin
      MessageDlg('Request created successfully.' + CRLF
      + 'Case number: ' + piece(success, '^', 2) + CRLF
      + 'Acc number:  ' + SpecAbbr + ' ' + piece(success, '^', 3), mtinformation, [mbOK], 0);
      ReqAction := '1^' + piece(success, '^', 2);
      PutFlag := 1;
      Close;
    end;
end;

procedure TfrmRequest.CollectData;
var
  J: integer;
begin
  if cbProc.Text = '' then LProcIFN := '';
  if cbCPT.Text  = '' then CPTIFN  := '';
  if cbLat.Text  = '' then LatIFN  := '';
  if cbRes.Text  = '' then ResIFN  := '';
  if cbAtt.Text  = '' then AttIFN  := '';
  if cbComp.Text = '' then CompIFN := '';
  if cbType.Text = '' then TypeIFN := '';
  if cbStat.Text = '' then StatIFN := '';
  if cbDis.Text  = '' then DisIFN  := '';
  if cbFroz.Text = '' then FrozIFN := '';
  if cbTS.Text   = '' then TSIFN   := '';
  if cbXray.Text = '' then XrayIFN := '';
  if cbSeq.Text  = '' then SeqIFN  := '';
  lbFinal.Clear;
  lbFinal.Items[0]  := LProcIFN + '^' + cbProc.Text + '^' + edProc.Text + '^' + CPTIFN + '^' + cbLat.Text;
  lbFinal.Items[1]  := Ptifn;
  lbFinal.Items[2]  := LatIFN + '^' + edLoc.Text;
  lbFinal.Items[3]  := '';
  if memFind.Lines[0] <> ''  then lbFinal.Items[3] := memFind.Lines[0] + '^' + memFind.Lines[1];
  lbFinal.Items[4]  := edDiag.Text;
  lbFinal.Items[5]  := '';
  lbFinal.Items[6]  := ResIFN;
  lbFinal.Items[7]  := AttIFN;
  lbFinal.Items[8]  := ''; // edTime.Text;       removed 1-14-08
  lbFinal.Items[9]  := edLen.Text;
  lbFinal.Items[10] := CompIFN;
  lbFinal.Items[11] := edOrd.Text;
  lbFinal.Items[12] := TypeIFN;   // check this
  lbFinal.Items[13] := StatIFN;   // check this
  lbFinal.Items[14] := DisIFN;
  lbFinal.Items[15] := edNeed.Text;
  lbFinal.Items[16] := memEq.Lines[0] + '^' + memEq.Lines[1];
  lbFinal.Items[17] := IntToStr(SpecIFN);
  lbFinal.Items[18] := IntToStr(NIFN);
  for J := 19 to 37 do lbFinal.Items[J] := '';
  if cbFroz.Text <> '' then lbFinal.Items[19] := FrozIFN;
  if cbTS.Text <> ''   then lbFinal.Items[20] := TSIFN;
  if cbXray.Text <> '' then lbFinal.Items[24] := XrayIFN;
  if cbSeq.Text <> ''  then lbFinal.Items[25] := SeqIFN;
  lbFinal.Items[26] := edRef.Text;
  if memScom.Lines[0] <> '' then lbFinal.Items[29] := memScom.Lines[0] + '^' + memScom.Lines[1];
  if cbRet.Text = 'Yes' then lbFinal.Items[30] := IntToStr(cbRet.ItemIEN) + '^' + SelectCase;
  if cbCon.Text = 'Yes' then lbFinal.Items[31] := IntToStr(cbCon.ItemIEN) + '^' + SelectCase;
  lbFinal.Items[32] := FloatToStr(dbDate.FMDateTime);
  lbFinal.Items[35] := wlifn;
  if cbPos.Text <> ''  then lbFinal.Items[36] := IntToStr(cbPos.ItemIEN);
  if Source = 1 then lbFinal.Items[37] := IntToStr(PCPConsult);
end;

procedure TfrmRequest.cbProcClick(Sender: TObject);
begin
  lblStar0.Caption := '';
  star0 := 0;
  LProcIFN := IntToStr(cbProc.ItemIEN);
  cbProc.Color := clWindow;
  if UsePTLD = 1 then edProc.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbLatClick(Sender: TObject);
begin
  lblStar1.Caption := '';
  star1 := 0;
  LatIFN := IntToStr(cbLat.ItemIEN);
  cbLat.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbResClick(Sender: TObject);
begin
  lblStar2.Caption := '';
  star2 := 0;
  ResIFN := IntToStr(cbRes.ItemIEN);
  cbRes.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbAttClick(Sender: TObject);
begin
  lblStar3.Caption := '';
  star3 := 0;
  AttIFN := IntToStr(cbAtt.ItemIEN);
  cbAtt.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbStatClick(Sender: TObject);
begin
  lblStar4.Caption := '';
  star4 := 0;
  StatIFN := IntToStr(cbStat.ItemIEN);
  cbStat.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbDisClick(Sender: TObject);
begin
  lblStar5.Caption := '';
  star5 := 0;
  DisIFN := IntToStr(cbDis.ItemIEN);
  cbDis.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbTypeClick(Sender: TObject);
begin
  lblStar6.Caption := '';
  star6 := 0;
  TypeIFN := cbType.ItemID;
  cbType.Color := clWindow;
  CheckReq := 0;
end;

function TfrmRequest.CheckEdit(): integer;
begin
  Result := 1;
  if lblStar0.Caption = '>' then
    begin
     star0 := 1;
     Result := 0;
    end;
  if lblStar1.Caption = '>' then
    begin
     star1 := 1;
     Result := 0;
    end;
  if lblStar2.Caption = '>' then
    begin
      star2 := 1;
      Result := 0;
    end;
  if lblStar3.Caption = '>' then
    begin
      star3 := 1;
      Result := 0;
    end;
  if lblStar4.Caption = '>' then
    begin
      star4 := 1;
      Result := 0;
    end;
  if lblStar5.Caption = '>' then
    begin
      star5 := 1;
      Result := 0;
    end;
  if lblStar6.Caption = '>' then
    begin
      star6 := 1;
      Result := 0;
    end;
end;

procedure TfrmRequest.cbProcChange(Sender: TObject);
begin
  CallV('APTWL GET PROC', [cbProc.Text]);
  cbProc.Items := RPCBrokerV.Results;
  cbProc.DroppedDown := True;
  Change := 1;
end;

procedure TfrmRequest.btnCWaitClick(Sender: TObject);
begin
  CurrentWait('W');
end;

procedure TfrmRequest.cbRetChange(Sender: TObject);
begin
  if cbRet.ItemIEN = 1 then
    begin
      OpsList(1, lstReturn);
      if piece(SelectCase, '^', 1) <> '0' then
        begin
          SRifn := StrToInt(piece(SelectCase, '^', 1));
          lblRetn.Caption := 'Prior case #: ' + IntToStr(SRifn);
          lblRetn.Visible := True;
          btnRet.Visible  := True;
          Change := 1;
        end
      else
        begin
          cbRet.Caption := 'No';
        end;
    end;
end;

procedure TfrmRequest.cbConChange(Sender: TObject);
begin
  if cbCon.ItemIEN = 1 then
    begin
      OpsList(2, lstConc);
      if piece(SelectCase, '^', 1) <> '0' then
        begin
          SRifn := StrToInt(piece(SelectCase, '^', 1));
          lblConn.Caption := 'Principal case #: ' + IntToStr(SRifn);
          lblConn.Visible := True;
          btnCon.Visible  := True;
          Change := 1;
        end
      else
        begin
          cbCon.Caption := 'No';
        end;
    end;
end;

procedure TfrmRequest.btnCReqClick(Sender: TObject);
begin
  CurrentRequest;
end;

procedure TfrmRequest.btnHoldClick(Sender: TObject);
begin
  dbdate.FMDateTime := 3250103;
end;

procedure TfrmRequest.EditRequest(ReqData: TStrings);
begin
  lblHdr2.Visible := False;
  btnReq.Visible  := False;
  frmRequest.Caption := 'Edit Surgical Request for ' + piece(ReqData[0], '^', 2);
end;

procedure TfrmRequest.btnSaveClick(Sender: TObject);
var
  Success: string;
begin
  if (Change = 0) then
    begin
      ShowMessage('No changes were made!');
      Exit;
    end;
  CollectData;
  Success := sCallV('APTWL SAVE REQ', [opcase, lbFinal.Items, lstBlood.Items, lstOther.Items, memBrief.Lines, memACom.Lines, memGCom.Lines]);
  if piece(Success, '^', 1) = '0' then
    begin
      MessageDlg(piece(Success, '^', 2), mterror, [mbOK], 0);
      Exit;
    end
  else
    begin
      MessageDlg('Edited Request saved successfully.' + CRLF
      + 'Acession: ' + SpecAbbr + ' ' + piece(Success, '^', 3), mtinformation, [mbOK], 0);
      Close;
    end;
end;

procedure TfrmRequest.cbLatChange(Sender: TObject);
begin
  Change :=1;
end;

procedure TfrmRequest.memFindChange(Sender: TObject);
begin
  Change :=1;
  memFind.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.edDiagChange(Sender: TObject);
begin
  Change := 1;
  edDiag.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.memBriefChange(Sender: TObject);
begin
  Change := 1;
  memBrief.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.edLenChange(Sender: TObject);
begin
  Change := 1;
  edLen.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.edOrderChange(Sender: TObject);
begin
  Change := 1;
  edOrd.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbTypeChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmRequest.cbStatChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmRequest.cbDisChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmRequest.edNeedChange(Sender: TObject);
begin
  Change := 1;
  edNeed.Color := clWindow;
  CheckReq := 0;
end;


procedure TfrmRequest.dbDateChange(Sender: TObject);
begin
  Change := 1;
  lblStar7.Caption := '';
  dbDate.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbFrozChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmRequest.cbTSChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmRequest.cbXrayChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmRequest.cbSeqChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmRequest.edRefChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmRequest.memAComChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmRequest.memSComChange(Sender: TObject);
begin
  Change := 1;
  memSCom.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.btnConClick(Sender: TObject);
begin
  CallV('APTWL GET REQ DETAIL', [piece(SelectCase, '^',1), 'R']);
  ReportBox(RPCBrokerV.Results, 'Surgery Detail for ' + PatName, True);
end;

procedure TfrmRequest.cbPosChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmRequest.cbPosClick(Sender: TObject);
begin
  PosIFN := IntToStr(cbPos.ItemIEN);
  cbPos.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbFrozClick(Sender: TObject);
begin
  FrozIFN := piece(cbFroz.Items[cbFroz.ItemIndex], '^', 1);
  cbFroz.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbTSClick(Sender: TObject);
begin
  TSIFN := IntToStr(cbTS.ItemIEN);
  cbTS.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbXrayClick(Sender: TObject);
begin
  XrayIFN := piece(cbXray.Items[cbXray.ItemIndex], '^', 1);
  cbXray.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbSeqClick(Sender: TObject);
begin
  SeqIFN := piece(cbSeq.Items[cbSeq.ItemIndex], '^', 1);
  cbSeq.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.btnBloodClick(Sender: TObject);
var
  I, Num: integer;
begin
  GetBlood(lstBlood);
  Num := lstBlood.Items.Count;
  lstBlood.Clear;
  with frmBlood do
    begin
      if lbBlood.Items.Count >0 then
        begin
          btnBlood.Font.Color := clRed;
          btnBlood.Color := clWindow;
          CheckReq := 0;
          for I := 0 to lbBlood.Items.Count-1 do lstBlood.Items.Add(lbBlood.Items[I]);
        end ;
      if lstBlood.Items.Count <> Num then Change := 1;
    end;
end;

procedure TfrmRequest.btnOtherClick(Sender: TObject);
var
  I, Num: integer;
  List: string;
begin
  List := 'R';
  GetOther(lstOther, List);
  Num := lstOther.Items.Count;
  lstOther.Clear;
  with frmOther do
    begin
      if lbOther.Items.Count >0 then
        begin
          btnSec.Color      := clRed;
          btnSec.Font.Color := clWhite;
          for I := 0 to lbOther.Items.Count-1 do lstOther.Items.Add(lbOther.Items[I]);
        end
      else
        begin
          btnSec.Color      := clBtnFace;
          btnSec.Font.Color := clWindowText;
        end;
      if OtherChange = 1 then
        begin
          Change   := 1;
          OtChange := 1;
        end;
    end;
end;

procedure TfrmRequest.btnRetClick(Sender: TObject);
begin
  cbRetChange(Self);
  //CallV('APTWL GET REQ DETAIL', [piece(SelectCase, '^',1), 'R']);
  //ReportBox(RPCBrokerV.Results, 'Surgery Detail for ' + PatName, True);
end;

procedure TfrmRequest.memEqChange(Sender: TObject);
begin
  Change := 1;
  memEq.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbCPTChange(Sender: TObject);
begin
  if cbCPT.Text = '' then Exit;
  CallV('APTWL GET CPT', [cbCPT.Text]);
  cbCPT.Items := RPCBrokerV.Results;
  cbCPT.DroppedDown := True;
  Change := 1;
end;

procedure TfrmRequest.cbCPTClick(Sender: TObject);
begin
  CPTIFN := IntToStr(cbCPT.ItemIEN);
  cbCPT.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbCompChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmRequest.cbCompClick(Sender: TObject);
begin
  CompIFN := IntToStr(cbComp.ItemIEN);
  cbCPT.Color := clWindow;
  CheckReq :=0;
end;

procedure TfrmRequest.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = 8 then
    begin
      if cbRes.Text = '' then
        begin
          lblStar2.Caption := '';
          ResIFN := '';
        end;
    end;
end;

procedure TfrmRequest.RequiredFields;
begin
  MessageDlg('Please enter data in all required fields.', mtwarning, [mbOK], 0);
end;

procedure TfrmRequest.MarkRequired;
begin
  Rdata := sCallV('APTWL GET REQUIRED', []);
  if piece(Rdata, '^', 1) = '1' then
    begin
      if UsePTLD = 1 then
        begin
          lblLocal.Font.Color  := clBlue;
          lblProc.Font.Color   := clBlue;
          lblFTProc.Font.Color := clBlue;
        end;
      if UsePTLD = 0 then lblFTProc.Font.Color := clBlue;
    end;
  if piece(Rdata, '^', 2)  = '1' then lblCPT.Font.Color   := clBlue;
  if piece(Rdata, '^', 3)  = '1' then lblLat.Font.Color   := clBlue;
  if piece(Rdata, '^', 4)  = '1' then lblPos.Font.Color   := clBlue;
  if piece(Rdata, '^', 5)  = '1' then lblFind.Font.Color  := clBlue;
  if piece(Rdata, '^', 6)  = '1' then lblDiag.Font.Color  := clBlue;
  if piece(Rdata, '^', 7)  = '1' then lblBrief.Font.Color := clBlue;
  if piece(Rdata, '^', 8)  = '1' then lblRes.Font.Color   := clBlue;
  if piece(Rdata, '^', 9)  = '1' then lblAtt.Font.Color   := clBlue;
  // if piece(Rdata, '^', 10) = '1' then lblSched.Font.Color := clBlue;   removed 1-14-08
  if piece(Rdata, '^', 11) = '1' then lblLen.Font.Color   := clBlue;
  if piece(Rdata, '^', 12) = '1' then lblComp.Font.Color  := clBlue;
  if piece(Rdata, '^', 13) = '1' then lblOrd.Font.Color   := clBlue;
  if piece(Rdata, '^', 14) = '1' then lblTyp.Font.Color   := clBlue;
  if piece(Rdata, '^', 15) = '1' then lblStat.Font.Color  := clBlue;
  if piece(Rdata, '^', 16) = '1' then lblDis.Font.Color   := clBlue;
  if piece(Rdata, '^', 17) = '1' then lblNeed.Font.Color  := clBlue;
  if piece(Rdata, '^', 18) = '1' then lblEq.Font.Color    := clBlue;
  if piece(Rdata, '^', 19) = '1' then lblDate.Font.Color  := clBlue;
  if piece(Rdata, '^', 20) = '1' then lblRet.Font.Color   := clBlue;
  if piece(Rdata, '^', 21) = '1' then lblCon.Font.Color   := clBlue;
  if piece(Rdata, '^', 22) = '1' then lblFroz.Font.Color  := clBlue;
  if piece(Rdata, '^', 23) = '1' then lblTS.Font.Color    := clBlue;
  if piece(Rdata, '^', 24) = '1' then btnBlood.Font.Color := clBlue;
  if piece(Rdata, '^', 25) = '1' then lblXray.Font.Color  := clBlue;
  if piece(Rdata, '^', 26) = '1' then lblSeq.Font.Color   := clBlue;
  if piece(Rdata, '^', 27) = '1' then lblScom.Font.Color  := clBlue;
  if piece(Rdata, '^', 28) = '1' then label1.Font.Color   := clBlue;
  if piece(Rdata, '^', 29) = '1' then label2.Font.Color   := clBlue;
  if piece(Rdata, '^', 30) = '1' then label3.Font.Color   := clBlue;
end;

procedure TfrmRequest.CheckRequired;
begin
  if piece(Rdata, '^', 1) = '1' then
    begin
      if (UsePTLD = 1) and (cbProc.Text = '') and (edProc.Text = '') then
        begin
          cbProc.Color := clSkyBlue;
          edProc.Color := clSkyBlue;
          CheckReq := 1;
        end;
      if (UsePTLD = 0) and (edProc.Text = '') then
        begin
          edProc.Color := clSkyBlue;
          CheckReq := 1;
        end;
    end;
    if (piece(Rdata, '^', 2) = '1') and (cbCPT.Text = '') then
      begin
        cbCPT.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 3) = '1') and (cbLat.Text = '') then
      begin
        cbLat.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 4) = '1') and (cbPos.Text = '') then
      begin
        cbPos.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 5) = '1') and (memFind.Lines[0] = '') then
      begin
        memFind.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 6) = '1') and (edDiag.Text = '') then
      begin
        edDiag.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 7) = '1') and (memBrief.Lines[0] = '') then
      begin
        memBrief.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 8) = '1') and (cbRes.Text = '') then
      begin
        cbRes.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 9) = '1') and (cbAtt.Text = '') then
      begin
        cbAtt.Color := clSkyBlue;
        CheckReq := 1;
      end;
    {if (piece(Rdata, '^', 10) = '1') and (edTime.Text = '') then
      begin
        edTime.Color := clSkyBlue;
        CheckReq := 1;
      end; }
    if (piece(Rdata, '^', 11) = '1') and (edLen.Text = '') then
      begin
        edLen.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 12) = '1') and (cbComp.Text = '') then
      begin
        cbComp.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 13) = '1') and (edOrd.Text = '') then
      begin
        edOrd.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 14) = '1') and (cbType.Text = '') then
      begin
        cbType.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 15) = '1') and (cbStat.Text = '') then
      begin
        cbStat.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 16) = '1') and (cbDis.Text = '') then
      begin
        cbDis.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 17) = '1') and (edNeed.Text = '') then
      begin
        edNeed.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 18) = '1') and (memEq.Lines[0] = '') then
      begin
        memEq.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 19) = '1') and (dbDate.Text = '') then
      begin
        dbDate.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 20) = '1') and (cbRet.Text = '') then
      begin
        cbRet.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 21) = '1') and (cbCon.Text = '') then
      begin
        cbCon.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 22) = '1') and (cbFroz.Text = '') then
      begin
        cbFroz.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 23) = '1') and (cbTS.Text = '') then
      begin
        cbTS.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 24) = '1') and (lstBlood.Count = 0) then
      begin
        btnBlood.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 25) = '1') and (cbXray.Text = '') then
      begin
        cbXray.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 26) = '1') and (cbSeq.Text = '') then
      begin
        cbSeq.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 27) = '1') and (memSCom.Lines[0] = '') then
      begin
        memSCom.Color := clSkyBlue;
        CheckReq := 1;
      end;
     if (piece(Rdata, '^', 28) = '1') and (cb1.Text = '') then
      begin
        cb1.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 29) = '1') and (cb2.Text = '') then
      begin
        cb2.Color := clSkyBlue;
        CheckReq := 1;
      end;
    if (piece(Rdata, '^', 30) = '1') and (cb3.Text = '') then
      begin
        cb3.Color := clSkyBlue;
        CheckReq := 1;
      end;
end;

procedure TfrmRequest.edProcClick(Sender: TObject);
begin
  edProc.Color := clWindow;
  if UsePTLD = 1 then cbProc.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbRetClick(Sender: TObject);
begin
  cbRet.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cbConClick(Sender: TObject);
begin
  cbCon.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cb1Click(Sender: TObject);
begin
  cb1.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cb2Click(Sender: TObject);
begin
  cb2.Color := clWindow;
  CheckReq := 0;
end;

procedure TfrmRequest.cb3Click(Sender: TObject);
begin
  cb3.Color := clWindow;
  CheckReq := 0;
end;

end.
